<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>Template &middot; Bootstrap</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="">

    <!-- Le styles -->
    <link href="../assets/css/bootstrap.css" rel="stylesheet">
    <style type="text/css">
      body {
        padding-top: 20px;
        padding-bottom: 60px;
      }

      .page-header {
        text-align: center;
      }

      .span6{
        text-align: center;
      }

      /* Custom container */
      .container {
        margin: 0 auto;
        max-width: 1200px;
      }
      .container > hr {
        margin: 60px 0;
      }

      /* Main marketing message and sign up button */
      .jumbotron {
        margin: 80px 0;
        text-align: center;
      }
      .jumbotron h1 {
        font-size: 100px;
        line-height: 1;
      }
      .jumbotron .lead {
        font-size: 24px;
        line-height: 1.25;
      }
      .jumbotron .btn {
        font-size: 21px;
        padding: 14px 24px;
      }

      /* Supporting marketing content */
      .marketing {
        margin: 60px 0;
      }
      .marketing p + h4 {
        margin-top: 28px;
      }


       Customize the navbar links to be fill the entire space of the .navbar 
      .navbar .navbar-inner {
        padding: 0;
      }
      .navbar .nav {
        margin: 0;
        display: table;
        width: 100%;
      }
      /*.navbar .nav li {
        display: table-cell;
        width: 1%;
        float: none;
      }*/
      .navbar .nav li a {
        font-weight: bold;
        text-align: center;
        border-left: 1px solid rgba(255,255,255,.75);
        border-right: 1px solid rgba(0,0,0,.1);
      }
      .navbar .nav li:first-child a {
        border-left: 0;
        border-radius: 3px 0 0 3px;
      }
      .navbar .nav li:last-child a {
        border-right: 0;
        border-radius: 0 3px 3px 0;
      }
    </style>
    <link href="../assets/css/bootstrap-responsive.css" rel="stylesheet">

    <!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="../assets/js/html5shiv.js"></script>
    <![endif]-->

    <!-- Fav and touch icons -->
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="../assets/ico/apple-touch-icon-144-precomposed.png">
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="../assets/ico/apple-touch-icon-114-precomposed.png">
      <link rel="apple-touch-icon-precomposed" sizes="72x72" href="../assets/ico/apple-touch-icon-72-precomposed.png">
                    <link rel="apple-touch-icon-precomposed" href="../assets/ico/apple-touch-icon-57-precomposed.png">
                                   <link rel="shortcut icon" href="../assets/ico/favicon.png">
  </head>

  <body>

    <div class="container">

      <div class="masthead">
        <h3 class="muted">Energie Control - ZedBox Network Configuration</h3>
        <div class="navbar navbar-inner container">
          <ul class="nav">
            <li <?php if ($_SERVER["REQUEST_URI"] == "/projet/index.php") {echo 'class="active"';} ?>><a href="./index.php">Accueil</a></li>
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">Ajouter <b class="caret"></b></a>
              <ul class="dropdown-menu">
                <li <?php if ($_SERVER["REQUEST_URI"] == "/projet/add_sensor.php") {echo 'class="active"';} ?>><a href="add_sensor.php">Capteur</a></li>
                <li <?php if ($_SERVER["REQUEST_URI"] == "/projet/add_WaterRadiator.php") {echo 'class="active"';} ?>><a href="add_WaterRadiator.php">Thermostat à eau chaude</a></li>
                <li <?php if ($_SERVER["REQUEST_URI"] == "/projet/add_ElectricRadiator.php") {echo 'class="active"';} ?>><a href="add_ElectricRadiator.php">Thermostat Electrique</a></li>
              </ul>
            </li>
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">Configuration <b class="caret"></b></a>
              <ul class="dropdown-menu">
                <li><a href="#">Localisation</a></li>
                <li><a href="#">Infrastructure</a></li>
                <li><a href="#">Base de donnée</a></li>
              </ul>
            </li>
          </ul>
        </div><!-- /.navbar -->
      </div>

      <div class="row">

      <!-- Jumbotron -->
      <div class="span12 jumbotron">
        <h2>Suivez votre consommation en temps réel !</h2>
        <p class="lead">Bienvenu sur l'interface de votre ZedBox. Cliquez sur Wizard-Config si c'est votre première utilisation !</p>
        <a class="btn btn-large btn-primary" href="#">Wizard - Config.</a>
      </div>

      <hr>

      <script type="text/javascript">

      function success(that)
      {
        if (that =='temp'){
          document.getElementById('success_temp').style.display="block";
        };
        return false;
      }

      function save_bat(that,type)
      {
        var valeur = 'bat'+that.options[that.selectedIndex].value;

        if (valeur=='batDefault'){
          document.getElementById('room_'+type).disabled=true;
        };

        for (var i = 1; i<=(that.length-1) ; i++) {
          if ((i == that.selectedIndex) && (valeur != "batDefault")) {
            document.getElementById('room_'+type).disabled=false;
            document.getElementById('bat_'+type+that.options[i].value).style.display="block";
          };
          if ((i != that.selectedIndex) && (valeur != "batDefault")) {
            document.getElementById('room_'+type).disabled=false;
            document.getElementById('bat_'+type+that.options[i].value).style.display="none";
          };

        }
        return false;
      }

    </script>

      <?php
        include('include/database.params.inc');
        $link=  mysqli_connect($machine,$user,$pwd,$db);
        /* Vérification de la connexion */
        if (mysqli_connect_errno()) {
            printf("Échec de la connexion MySQL : %s\n", mysqli_connect_error());
            exit();
        }
      ?>

        <section class="forcast">
        <form class="span6">  
          <label for="forcast"><h5 class="page-header">Prévisions Météo</h5></label>
        </form>
        </section>

        <section class="consommation">
        <form class="span6">  
          <label for="consommation"><h5 class="page-header">consommation</h5></label>
        </form>
        </section>

        <section id="temp_in_room">
        <form class="span6" align="center" method="POST">
            <label for="bat_temp"><h5 class="page-header">Quelle température dans cette pièce ?</h5></label>
            <select name="Batiment_temp" id="Batiment_temp" onChange="save_bat(this,'temp')">
              <option value="Default">Sélectionnez un batiment</option>

                <!-- Requête SQL -->

                <?php
                  $query= "SELECT * FROM View_temp_piece";
              $result = mysqli_query($link, $query) or die("Erreur SQL".mysqli_error());
                  $num = mysqli_num_rows($result);
              $i = 0;
              while ($i < $num){
                mysqli_data_seek($result,$i);
                $row = mysqli_fetch_row($result);
                    echo "<option value=".$row[0].">".$row[0]."</option>";
                    $i++;
                  }
                ?>

            </select>
            <select name="room_temp" id="room_temp" disabled="true" onChange="submit()">
                <option value="Default">Sélectionnez une pièce</option>

                <?php
                  $query2= "SELECT * FROM View_temp_piece";
              $result2 = mysqli_query($link, $query2) or die("Erreur SQL".mysqli_error());
                  $num2 = mysqli_num_rows($result2);
              $i = 0;
              while ($i < $num2){
                mysqli_data_seek($result2,$i);
                $row2 = mysqli_fetch_row($result2);
                echo "<option id='bat_temp".$row2[0]."' value=".$row2[1].">".$row2[1]."</option>";
                    $i++;
                  }
                ?>
            </select>
             <div id="success_temp" class="alert alert-success inline" style="display:none">
              <a href="" class="close">x</a>
              <?php
              $i = 0;
              while ($i < $num){
                mysqli_data_seek($result,$i);
                $row = mysqli_fetch_row($result);
                if ($_POST['Batiment_temp']==$row[0] & $_POST['room_temp']==$row[1]) {
                  echo "<script type='text/javascript'>success('temp')</script>
                  <p>Température de ".$row[1]." en ".$row[0]." : <strong>".number_format($row[2], 2)." °C</strong></p>";
                }
                $i++;
                  }
              ?>
            </div>
        </form>
        </section>
        <section class="radiator_status">
        <form class="span6" align="center"> 
          <label for="bat_rad"><h5 class="page-header">Mode manuel Radiateur</h5></label>
            <select name="Batiment_rad" id="Batiment_rad" onChange="save_bat(this,'rad')">
              <option value="Default">Sélectionnez un batiment</option>
              <?php 
                $num = mysqli_num_rows($result);
              $i = 0;
              while ($i < $num){
                mysqli_data_seek($result,$i);
                $row = mysqli_fetch_row($result);
                  echo "<option value=".$row[0].">".$row[0]."</option>";
                  $i++;
                }
              ?>
            </select>
            <select name="room_rad" id="room_rad" disabled="true">
                <option value="Default">Sélectionnez une pièce</option>

              <?php
                $query2= "SELECT * FROM View_temp_piece";
              $result2 = mysqli_query($link, $query2) or die("Erreur SQL".mysqli_error());
                $num2 = mysqli_num_rows($result2);
              $i = 0;
              while ($i < $num2){
                mysqli_data_seek($result2,$i);
                $row2 = mysqli_fetch_row($result2);
                echo "<option id='bat_rad".$row2[0]."' value=".$row2[1].">".$row2[1]."</option>";
                $i++;
                }
              ?>
          </select>
        </form>
        </section>

      </div>

      <hr>

      <div id="footer">
        <div class="container">
          <p class="pull-right"><a href="#">Back to top</a></p>
          <p class="muted credit">
            &copy; Powered by F. Royer and J. Gondry IMA4.
          </p>
        </div>
      </div>

    </div> <!-- /container -->

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="../assets/js/jquery.js"></script>
    <script src="../assets/js/bootstrap-transition.js"></script>
    <script src="../assets/js/bootstrap-alert.js"></script>
    <script src="../assets/js/bootstrap-modal.js"></script>
    <script src="../assets/js/bootstrap-dropdown.js"></script>
    <script src="../assets/js/bootstrap-scrollspy.js"></script>
    <script src="../assets/js/bootstrap-tab.js"></script>
    <script src="../assets/js/bootstrap-tooltip.js"></script>
    <script src="../assets/js/bootstrap-popover.js"></script>
    <script src="../assets/js/bootstrap-button.js"></script>
    <script src="../assets/js/bootstrap-collapse.js"></script>
    <script src="../assets/js/bootstrap-carousel.js"></script>
    <script src="../assets/js/bootstrap-typeahead.js"></script>

  </body>
</html>
